/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.recipes.cheese;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfyu.meadow.registry.RecipeRegistry;

public class CheeseFormRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient bucket;
    private final Ingredient ingredient;
    private final ItemStack result;

    public CheeseFormRecipe(ResourceLocation id, Ingredient bucket, Ingredient ingredient, ItemStack result) {
        this.id = id;
        this.bucket = bucket;
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean m_5818_(Container inventory, Level world) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(List.of(inventory.m_8020_(1), inventory.m_8020_(2)));
        for (Ingredient ingredient : ingredients) {
            boolean matches = false;
            for (ItemStack stack : items) {
                if (!ingredient.test(stack)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList defaultedList = NonNullList.m_122779_();
        defaultedList.add((Object)this.bucket);
        defaultedList.add((Object)this.ingredient);
        return defaultedList;
    }

    public ItemStack m_5874_(Container inventory) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.CHEESE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.CHEESE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CheeseFormRecipe> {
        public CheeseFormRecipe read(ResourceLocation id, JsonObject json) {
            JsonElement jsonResultElement = json.get("result");
            ItemStack resultItem = GsonHelper.m_13874_((JsonElement)jsonResultElement, (String)jsonResultElement.getAsString()).m_7968_();
            JsonObject jsonBucketObject = json.getAsJsonObject("bucket");
            Ingredient bucket = Ingredient.m_43917_((JsonElement)jsonBucketObject);
            JsonObject jsonIngredientObject = json.getAsJsonObject("ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonIngredientObject);
            return new CheeseFormRecipe(id, bucket, ingredient, resultItem);
        }

        public void write(FriendlyByteBuf packetData, CheeseFormRecipe recipe) {
            recipe.m_7527_().forEach(ingredient -> ingredient.m_43923_(packetData));
            packetData.m_130055_(recipe.m_8043_());
        }

        public CheeseFormRecipe read(ResourceLocation id, FriendlyByteBuf packetData) {
            Ingredient bucket = Ingredient.m_43940_((FriendlyByteBuf)packetData);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)packetData);
            ItemStack output = packetData.m_130267_();
            return new CheeseFormRecipe(id, bucket, input, output);
        }
    }
}

